%% join.m
 
%% Function to compute the join of "n" type-1 fuzzy sets under minimum or 
%% product t-norms, using Theorem A-1 in the book Uncertain Rule-Based 
%% Fuzzy Logic Systems: Introduction and New Directions, by Jerry M. Mendel, 
%% and published by Prentice-Hall, 2000.

%% Written by Nilesh N. Karnik - July 21,1998
%% For use with MATLAB 5.1 or higher.

%% Outputs : "out" and "mem" (vectors) are, respectively, 
%% the domain and the memberships of the result of the "join" operation. 
 
%% Inputs : "x" is an "m" vector containing the domain elements of the 
%% type-1 sets participating in the join operation. All the sets are 
%% supposed to have the same domain. This is not at all a restrictive 
%% assumption, as the sets we deal with are generally subsets of the 
%% real line. "Y" is an "n x m" vector containing the membership grades 
%% of the "n" type-1 fuzzy sets. "tnorm" is a scalar. If "tnorm < 0", 
%% minimum t-norm is used, otherwise product t-norm is used.


function[out,mem] = join(x,Y,tnorm)

[n,m] = size(Y) ;  

for i1 = 1 : n,
    in1 = find(Y(i1,:) == 1) ;
    v1(i1) = in1(1) ;
end  %%% for i1 

[v,in2] = sort(v1) ;
Y1 = Y(in2,:) ;

out = x ;

if tnorm <= 0,
   tstr = 'min' ;
else
   tstr = 'prod' ;
end   % if tnorm

mem(1:v(1)) = feval(tstr , Y1(:,1:v(1))) ;

for i1 = 1 : n-1,
    if i1 < n-1 ,
       mem(v(i1)+1 : v(i1+1)) = feval(tstr, Y1(i1+1:n, v(i1)+1 : v(i1+1))) ;
    else
       mem(v(i1)+1 : v(i1+1)) = Y1(n, v(i1)+1 : v(i1+1)) ;
    end   % if i1
end  %% for i1

mem(v(n)+1 : m) = max(Y1(: , v(n)+1 : m)) ;   

return ;











